#ifndef ARROWS_H
#define ARROWS_H

/* char arrays */
static const char instructions[] =
"The object of the game is to select which direction the centre arrow is facing:\n"
"left or right. Use your keyboard's arrow keys to select or hit 'q' to quit the\n"
"game. Scoring starts once you make your first move.\n\n";

/* #defines (for directions) */
#define NONE	0
#define LEFT	1
#define RIGHT	2
#define LENGTH	40

/* Number of seconds to delay (in non-blocking mode): if no input before
 * this point the loops count will be updated and the score will stay the same.
 * To define pass to the compiler: -DDELAY=<secs>
 */
#ifndef DELAY
#define DELAY 1.2 /* 1.2s */
#endif
#define DELAY_MS (double)DELAY * (double)1000

/* These constants are for the pRNG used in this game; the algorithm is taken
 * from the paper 'Random Number Generators: Good Ones Are To Find', an article
 * I first learnt of from my MUD development days (though the MUD I worked on
 * was heavily modified we still were bound to the original license at least for
 * that version of the MUD).
 *
 * Don't change these.
 */
#define m 2147483647UL
#define q 127773UL
#define a 16807UL
#define r 2836UL

/* Part of the pRNG as well. */
static unsigned long seed;
/* Functions for the pRNG */
static unsigned long prng();
static unsigned long number(unsigned long from, unsigned long to);

static void setup();

/* curses specific */
static void init_screen();
static void update_screen();
static void init_keyboard();
static void print_spaces();

/* Game functions */
static void display_score(unsigned long long score, unsigned long long loops);
static void play();

#endif /* ARROWS_H */
